package pt.caf_pbs.schooldiskapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@JsonIgnoreProperties(value = {"all"})
public class StudentContainer implements Serializable {
    private List<Student> students;
    private EnrollContainer enrolls;

    public StudentContainer() {
        students = new ArrayList<Student>();
    }

    public List<Student> getStudents() {
        return students;
    }

    public void setStudents(List<Student> students) {
        this.students = students;
    }

    public EnrollContainer getEnrolls() {
        return enrolls;
    }

    public void setEnrolls(EnrollContainer enrolls) {
        this.enrolls = enrolls;
    }

    private Student search(int number) {
        Student student;
        Iterator<Student> it = this.students.iterator();
        while (it.hasNext()) {
            student = it.next();
            if (student.isEqualTo(number)) {
                return student;
            }
        }
        return null;
    }

    public List<Student> getAll() {
        List<Student> newlist = new ArrayList();
        newlist.addAll(this.students);
        return newlist;
    }

    public Student get(int number) {
        Student student = search(number);
        return student;
    }

    public void add(Student obj) {
        Student student = search(obj.getNumber());
        if (student == null) {
            this.students.add(obj);
        } else {
            String msg = "Student: " + obj.getNumber();
            throw new DuplicatedDataException(msg);
        }
    }

    public void remove(int number) {
        Student student = search(number);
        if (student != null) {
            this.students.remove(student);
        }
    }

    public void update(int number, String name, Date date) {
        Student student = search(number);
        if (student != null) {
            student.setName(name);
            student.setBirthday(date);
        }
    }
}
